/******************************************************************************
*                                                  
*  (c) copyright Freescale Semiconductor 2008
*  ALL RIGHTS RESERVED
*
*  File Name: main.c
*                                                                          
*  Purpose: This file is for a USB Mass-Storage Device bootloader.  This file 
*           has the main routine for the user application with the bootloader.
*           In this case, the application simply blinks an LED on PTF1 using
*           a timer interrupt.  
*                                                                          
*  Assembler:  Codewarrior for Microcontrollers V6.2
*                                            
*  Version:  1.1
*                                                                          
*                                                                          
*  Author: Derek Snell                             
*                                                                                       
*  Location: Indianapolis, IN. USA                                            
*                                                                                  
* UPDATED HISTORY:
*
* REV   YYYY.MM.DD  AUTHOR        DESCRIPTION OF CHANGE
* ---   ----------  ------        --------------------- 
* 1.1   2009.01.12  Derek Snell   Ported to S08 from V1
* 1.0   2008.06.10  Derek Snell   Initial version
* 
*
******************************************************************************/                                                                        
/* Freescale  is  not  obligated  to  provide  any  support, upgrades or new */
/* releases  of  the Software. Freescale may make changes to the Software at */
/* any time, without any obligation to notify or provide updated versions of */
/* the  Software  to you. Freescale expressly disclaims any warranty for the */
/* Software.  The  Software is provided as is, without warranty of any kind, */
/* either  express  or  implied,  including, without limitation, the implied */
/* warranties  of  merchantability,  fitness  for  a  particular purpose, or */
/* non-infringement.  You  assume  the entire risk arising out of the use or */
/* performance of the Software, or any systems you design using the software */
/* (if  any).  Nothing  may  be construed as a warranty or representation by */
/* Freescale  that  the  Software  or  any derivative work developed with or */
/* incorporating  the  Software  will  be  free  from  infringement  of  the */
/* intellectual property rights of third parties. In no event will Freescale */
/* be  liable,  whether in contract, tort, or otherwise, for any incidental, */
/* special,  indirect, consequential or punitive damages, including, but not */
/* limited  to,  damages  for  any loss of use, loss of time, inconvenience, */
/* commercial loss, or lost profits, savings, or revenues to the full extent */
/* such  may be disclaimed by law. The Software is not fault tolerant and is */
/* not  designed,  manufactured  or  intended by Freescale for incorporation */
/* into  products intended for use or resale in on-line control equipment in */
/* hazardous, dangerous to life or potentially life-threatening environments */
/* requiring  fail-safe  performance,  such  as  in the operation of nuclear */
/* facilities,  aircraft  navigation  or  communication systems, air traffic */
/* control,  direct  life  support machines or weapons systems, in which the */
/* failure  of  products  could  lead  directly to death, personal injury or */
/* severe  physical  or  environmental  damage  (High  Risk Activities). You */
/* specifically  represent and warrant that you will not use the Software or */
/* any  derivative  work of the Software for High Risk Activities.           */
/* Freescale  and the Freescale logos are registered trademarks of Freescale */
/* Semiconductor Inc.                                                        */ 
/*****************************************************************************/

#include "derivative.h" /* include peripheral declarations */
#include "Bootloader_S08.h"
#include <hidef.h>

void _Startup(void);

// User Application code entry
volatile const JumpVect UsrEntry@ USER_ENTRY_ADDRESS = {
  0xCC,     // op-code for JMP
  _Startup
};

__interrupt void Timer_Overflow(void)
{

   TPM1SC_TOF = 0;     // clear flag
   PTFD_PTFD1 ^=1;

}

interrupt void Dummy_ISR(void) {
  
}

// User Interrupt Jump Vector Table
volatile const JumpVect UserJumpVectors[InterruptVectorsNum]@ VectorAddressTableAddress = { 
    { 0xCC, Dummy_ISR},                 // 29 - RTC
    { 0xCC, Dummy_ISR},                 // 28 - IIC
    { 0xCC, Dummy_ISR},                 // 27 - ACMP
    { 0xCC, Dummy_ISR},                 // 26 - ADC Conversion
    { 0xCC, Dummy_ISR},                 // 25 - KBI
    { 0xCC, Dummy_ISR},                 // 24 - SCI2 Transmit
    { 0xCC, Dummy_ISR},                 // 23 - SCI2 Receive
    { 0xCC, Dummy_ISR},                 // 22 - SCI2 Error
    { 0xCC, Dummy_ISR},                 // 21 - SCI1 Transmit
    { 0xCC, Dummy_ISR},                 // 20 - SCI1 Receive
    { 0xCC, Dummy_ISR},                 // 19 - SCI1 Error
    { 0xCC, Dummy_ISR},                 // 18 - TPM2 Overflow
    { 0xCC, Dummy_ISR},                 // 17 - TPM2 Channel1
    { 0xCC, Dummy_ISR},                 // 16 - TPM2 Channel0
    { 0xCC, Timer_Overflow},            // 15 - TPM1 Overflow
    { 0xCC, Dummy_ISR},                 // 14 - TPM1 Channel5
    { 0xCC, Dummy_ISR},                 // 13 - TPM1 Channel4
    { 0xCC, Dummy_ISR},                 // 12 - TPM1 Channel3
    { 0xCC, Dummy_ISR},                 // 11 - TPM1 Channel2
    { 0xCC, Dummy_ISR},                 // 10 - TPM1 Channel1
    { 0xCC, Dummy_ISR},                 //  9 - TPM1 Channel0
    { 0xCC, Dummy_ISR},                 //  8 - Reserved
    { 0xCC, Dummy_ISR},                 //  7 - USB Status
    { 0xCC, Dummy_ISR},                 //  6 - SPI2
    { 0xCC, Dummy_ISR},                 //  5 - SPI1
    { 0xCC, Dummy_ISR},                 //  4 - MCG Loss of Lock
    { 0xCC, Dummy_ISR},                 //  3 - Low Voltage Detect
    { 0xCC, Dummy_ISR},                 //  2 - IRQ
    { 0xCC, Dummy_ISR},                 //  1 - SWI
};


void main(void) {


  /* !! Start application code below here !! */

  SOPT1 = 0x00;                     // disable COP
  SOPT2 = 0x00;       

  EnableInterrupts; 
  
  PTFDD_PTFDD1 = 1;
  
  TPM1SC_CLKSx = 0x01;   // bus clock
  TPM1SC_PS = 7;        // 1/128 bus clock
  
  TPM1SC_TOIE = 1;
  
  for(;;) {
  } /* loop forever */
  /* please make sure that you never leave main */
}
